<?php
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/util.php";
    include "../include/costanti.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../gUtil/ElaboratoreImmagini.php";
    include "../classi/GestoreHtaccess.php";
    include "../classi/GeneratoreUrl.php";
    
    session_start();
    controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
    
    // i dati del database sono definiti nel file costanti.php
    $geecomDb     = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_ADD_SLASHES);
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
    }

    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom = $geecomDb->leggiSingolaRiga("geec_prodotti", 3) ;
    $percorsoGeecomDoc = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    switch ($operazione) {
        case 'aggiornaCampoTabella':
            $tabella = filter_input(INPUT_GET,"tabella",FILTER_SANITIZE_ADD_SLASHES);
            $id      = filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT);
            $campo   = filter_input(INPUT_GET,"campo",FILTER_SANITIZE_ADD_SLASHES);
            $valore  = filter_input(INPUT_GET,"valore",FILTER_SANITIZE_ADD_SLASHES);
            
            $query = "UPDATE $tabella SET $campo='$valore' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($query);
            echo "ok";
            break;
        case 'aggiornaImpostazioniGenerali':
            $nomePiattaforma             = filter_input(INPUT_POST,"nomePiattaforma",FILTER_SANITIZE_ADD_SLASHES);
            $descrizioneSito             = filter_input(INPUT_POST,"descrizioneSito",FILTER_SANITIZE_ADD_SLASHES);
            $urlPiattaforma              = filter_input(INPUT_POST,"urlPiattaforma",FILTER_SANITIZE_ADD_SLASHES);
            $dimensioneMassimaFileInMb   = filter_input(INPUT_POST,"dimensioneMassimaFileInMb",FILTER_SANITIZE_NUMBER_INT);
            $numeroVersioniDocumento     = filter_input(INPUT_POST,"numeroVersioniDocumento",FILTER_SANITIZE_NUMBER_INT);
            $spazioSuDiscoDaOccupareInMb = filter_input(INPUT_POST,"spazioSuDiscoDaOccupareInMb",FILTER_SANITIZE_NUMBER_INT);
            $confermaMailPaginaApprovazione = filter_input(INPUT_POST,"confermaMailPaginaApprovazione",FILTER_SANITIZE_ADD_SLASHES);
            $confermaMailPaginaCondivisione = filter_input(INPUT_POST,"confermaMailPaginaCondivisione",FILTER_SANITIZE_ADD_SLASHES);
            $inviaNotificaNuovoDocumento     = filter_input(INPUT_POST,"inviaNotificaNuovoDocumento",FILTER_SANITIZE_ADD_SLASHES);
            $inviaNotificaNuovaVersioneDocumento = filter_input(INPUT_POST,"inviaNotificaNuovaVersioneDocumento",FILTER_SANITIZE_ADD_SLASHES);
            $inviaNotificaScaricamento       = filter_input(INPUT_POST,"inviaNotificaScaricamento",FILTER_SANITIZE_ADD_SLASHES);
            
            $query = "UPDATE geecD_impostazioni SET nomePiattaforma='$nomePiattaforma', descrizioneSito='$descrizioneSito', urlPiattaforma='$urlPiattaforma', dimensioneMassimaFileInMb='$dimensioneMassimaFileInMb', numeroVersioniDocumento='$numeroVersioniDocumento', spazioSuDiscoDaOccupareInMb='$spazioSuDiscoDaOccupareInMb', confermaMailPaginaApprovazione='$confermaMailPaginaApprovazione', confermaMailPaginaCondivisione='$confermaMailPaginaCondivisione', inviaNotificaNuovoDocumento='$inviaNotificaNuovoDocumento', inviaNotificaNuovaVersioneDocumento='$inviaNotificaNuovaVersioneDocumento', inviaNotificaScaricamento='$inviaNotificaScaricamento' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($query);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=200");
            break;
        case 'aggiornaImpostazioniTemplateCartelle':
            $creaCartellaRadiceNuovoUtente    = filter_input(INPUT_POST,"creaCartellaRadiceNuovoUtente",FILTER_SANITIZE_ADD_SLASHES);
            $prefissoCartellaRadice           = filter_input(INPUT_POST,"prefissoCartellaRadice",FILTER_SANITIZE_ADD_SLASHES);
            $campoDaUsareNomeCartellaRadice   = filter_input(INPUT_POST,"campoDaUsareNomeCartellaRadice",FILTER_SANITIZE_ADD_SLASHES);
            $creaSottocartelleDaTemplate      = filter_input(INPUT_POST,"creaSottocartelleDaTemplate",FILTER_SANITIZE_ADD_SLASHES);
            $usaUnicaCartellaRadiceSuperAdmin = filter_input(INPUT_POST,"usaUnicaCartellaRadiceSuperAdmin",FILTER_SANITIZE_ADD_SLASHES);
            $templateCartelle                 = filter_input(INPUT_POST,"templateCartelle",FILTER_SANITIZE_NUMBER_INT);
            
            $query = "UPDATE geecD_impostazioni SET creaCartellaRadiceNuovoUtente='$creaCartellaRadiceNuovoUtente', prefissoCartellaRadice='$prefissoCartellaRadice', campoDaUsareNomeCartellaRadice='$campoDaUsareNomeCartellaRadice', creaSottocartelleDaTemplate='$creaSottocartelleDaTemplate', usaUnicaCartellaRadiceSuperAdmin='$usaUnicaCartellaRadiceSuperAdmin', templateCartelle='$templateCartelle' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($query);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=295");
            break;
        case 'eseguiOperazioniMassive':

            header("Location: $percorsoGeecomDoc/impostazioni.php?status=296");
            break;
        case 'aggiornaProfiliSocial':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $facebook  = filter_input(INPUT_POST,"facebook",FILTER_SANITIZE_URL);
            $instagram = filter_input(INPUT_POST,"instagram",FILTER_SANITIZE_URL);
            $twitter   = filter_input(INPUT_POST,"twitter",FILTER_SANITIZE_URL);
            $linkedin  = filter_input(INPUT_POST,"linkedin",FILTER_SANITIZE_URL);
            $youtube   = filter_input(INPUT_POST,"youtube",FILTER_SANITIZE_URL);
            $patreon   = filter_input(INPUT_POST,"patreon",FILTER_SANITIZE_URL);
            $ticToc    = filter_input(INPUT_POST,"ticToc",FILTER_SANITIZE_URL);
            $whatsapp  = filter_input(INPUT_POST,"whatsapp",FILTER_SANITIZE_URL);
            $telegram  = filter_input(INPUT_POST,"telegram",FILTER_SANITIZE_URL);

            $queryAggiornamentoDati ="UPDATE geec_profiliSocial SET facebook='$facebook', twitter='$twitter', linkedin='$linkedin', youtube='$youtube', patreon='$patreon', ticToc='$ticToc', instagram='$instagram', whatsapp='$whatsapp', telegram='$telegram'  WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoDati);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=245");
            break;
        case 'aggiornaImpostazioniRegistrazione':
            // aggiorno i dati del modulo registrazione
            $richiediNome           = filter_input(INPUT_POST, "richiediNome",FILTER_SANITIZE_ADD_SLASHES);
            $richiediCognome        = filter_input(INPUT_POST, "richiediCognome",FILTER_SANITIZE_ADD_SLASHES);
            $richiediCitta          = filter_input(INPUT_POST, "richiediCitta",FILTER_SANITIZE_ADD_SLASHES);
            $richiediTelefono       = filter_input(INPUT_POST, "richiediTelefono",FILTER_SANITIZE_ADD_SLASHES);
            $richiediEmail          = filter_input(INPUT_POST, "richiediEmail",FILTER_SANITIZE_ADD_SLASHES);
            $richiediPassword       = filter_input(INPUT_POST, "richiediPassword",FILTER_SANITIZE_ADD_SLASHES);
            $richiediOrganizzazione = filter_input(INPUT_POST, "richiediOrganizzazione",FILTER_SANITIZE_ADD_SLASHES);
            $richiediGruppo         = filter_input(INPUT_POST, "richiediGruppo",FILTER_SANITIZE_ADD_SLASHES);
            $inviaPasswordViaEmail  = filter_input(INPUT_POST, "inviaPasswordViaEmail",FILTER_SANITIZE_ADD_SLASHES);
            $testoRegistrazione     = filter_input(INPUT_POST, "contenutoEmailRegistrazione",FILTER_SANITIZE_ADD_SLASHES);
            $inviaMailConferma      = filter_input(INPUT_POST, "inviaMailConferma",FILTER_SANITIZE_ADD_SLASHES);
            $inviaNotificaNuovoUtente = filter_input(INPUT_POST, "inviaNotificaNuovoUtente",FILTER_SANITIZE_ADD_SLASHES);
            $mailNotificheNuoviUtenti = filter_input(INPUT_POST, "mailNotificheNuoviUtenti",FILTER_SANITIZE_ADD_SLASHES);
            
            $queryAggiornamento     = "UPDATE geecD_moduliRegistrazione SET richiediNome='$richiediNome', richiediCognome='$richiediCognome', richiediCitta='$richiediCitta', richiediTelefono='$richiediTelefono', richiediEmail='$richiediEmail', richiediPassword='$richiediPassword', richiediGruppo='$richiediGruppo', inviaPasswordViaEmail='$inviaPasswordViaEmail', contenutoEmailRegistrazione='$testoRegistrazione', richiediOrganizzazione='$richiediOrganizzazione', inviaMailConferma='$inviaMailConferma', inviaNotificaNuovoUtente='$inviaNotificaNuovoUtente', mailNotificheNuoviUtenti='$mailNotificheNuoviUtenti' WHERE id=1";
            $risImpostazioniFooter  = $geecomDb->eseguiQueryScrittura($queryAggiornamento);

            $registrazioneUtenti   = filter_input(INPUT_POST,"registrazioneUtenti",FILTER_SANITIZE_ADD_SLASHES);
            $gruppoDefault         = filter_input(INPUT_POST,"gruppoDefault",FILTER_SANITIZE_ADD_SLASHES);
            $statoInizialeNuoviUtenti = filter_input(INPUT_POST,"statoInizialeNuoviUtenti",FILTER_SANITIZE_ADD_SLASHES);
            $accessoFacebook       = filter_input(INPUT_POST,"accessoFacebook",FILTER_SANITIZE_ADD_SLASHES);
            $accessoGoogle         = filter_input(INPUT_POST,"accessoGoogle",FILTER_SANITIZE_ADD_SLASHES);
            
            $query = "UPDATE geecD_impostazioni SET registrazioneUtenti='$registrazioneUtenti', gruppoDefault='$gruppoDefault', statoInizialeNuoviUtenti='$statoInizialeNuoviUtenti', accessoFacebook='$accessoFacebook', accessoGoogle='$accessoGoogle'  WHERE id=1";
            $geecomDb->eseguiQueryScrittura($query);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=210");
            break;
        case 'aggiornaImpostazioniContabilita':
            
            $attivaContabilita = filter_input(INPUT_POST,"attivaContabilita",FILTER_SANITIZE_ADD_SLASHES);
            $tipoContabilita   = filter_input(INPUT_POST,"tipoContabilita",FILTER_SANITIZE_ADD_SLASHES);
            $percentualeIva    = filter_input(INPUT_POST,"percentualeIva",FILTER_SANITIZE_NUMBER_INT);
            $gruppoClienti     = filter_input(INPUT_POST,"gruppoClienti",FILTER_SANITIZE_NUMBER_INT);
            $gruppoFornitori   = filter_input(INPUT_POST,"gruppoFornitori",FILTER_SANITIZE_NUMBER_INT);
            $intestazioneDocumentiFiscali = filter_input(INPUT_POST,"intestazioneDocumentiFiscali",FILTER_SANITIZE_ADD_SLASHES);
            
            $query = "UPDATE geecD_impostazioni SET attivaContabilita='$attivaContabilita', percentualeIva='$percentualeIva', gruppoClienti='$gruppoClienti', gruppoFornitori='$gruppoFornitori', intestazioneDocumentiFiscali='$intestazioneDocumentiFiscali', tipoContabilita='$tipoContabilita' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($query);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=220");
            break;
        case 'aggiornaImpostazioniLingue':    
            $impostazioniItaliano  = $geecomDb->escapeString($_POST['impostazioniItaliano']);
            $menuItaliano = $geecomDb->escapeString($_POST['menuItaliano']);
            $homePage = $geecomDb->escapeString($_POST['homePageItaliano']);

            $impostazioniInglese  = $geecomDb->escapeString($_POST['impostazioniInglese']);
            $menuInglese = $geecomDb->escapeString($_POST['menuInglese']);
            $homePageEn = $geecomDb->escapeString($_POST['homePageInglese']);

            $impostazioniTedesco = $geecomDb->escapeString($_POST['impostazioniTedesco']);
            $menuTedesco         = $geecomDb->escapeString($_POST['menuTedesco']);
            $homePageDe          = $geecomDb->escapeString($_POST['homePageDe']);

            $impostazioniFrancese  = $geecomDb->escapeString($_POST['impostazioniFrancese']);
            $menuFrancese = $geecomDb->escapeString($_POST['menuFrancese']);
            $impostazioniSpagnolo  = $geecomDb->escapeString($_POST['impostazioniSpagnolo']);
            $menuSpagnolo = $geecomDb->escapeString($_POST['menuSpagnolo']);

            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoLingue = "UPDATE geecD_impostazioniLingue SET impostazioniItaliano='$impostazioniItaliano',menuItaliano='$menuItaliano',impostazioniInglese='$impostazioniInglese',menuInglese='$menuInglese',
    impostazioniTedesco='$impostazioniTedesco', menuTedesco='$menuTedesco', impostazioniFrancese='$impostazioniFrancese',menuFrancese='$menuFrancese',impostazioniSpagnolo='$impostazioniSpagnolo',menuSpagnolo='$menuSpagnolo'
    WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoLingue);

            //aggiorno le impostazioni delle home (attualmente nella tabella impostazioni)
            $queryAggiornamentoImpostazioni = "UPDATE geecD_impostazioni SET homePage='$homePage', homePageEn='$homePageEn' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoImpostazioni);
            
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=500");
            break;
        case 'aggiornaImpostazioniFooter':
            $idFooter              = filter_input(INPUT_POST,"id", FILTER_SANITIZE_NUMBER_INT);
            $lingua                = filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_ADD_SLASHES);
            $attivaFooterSuperiore = $geecomDb->escapeString($_POST["attivaFooterSuperiore"]);
            $numeroColonne = $geecomDb->escapeString($_POST["numeroColonne"]);
            $colonna1 = $geecomDb->escapeString($_POST["colonna1"]);
            $colonna2 = $geecomDb->escapeString($_POST["colonna2"]);
            $colonna3 = $geecomDb->escapeString($_POST["colonna3"]);
            $colonna4 = $geecomDb->escapeString($_POST["colonna4"]);

            $titoloColonna1 = $geecomDb->escapeString($_POST["titoloColonna1"]);
            $titoloColonna2 = $geecomDb->escapeString($_POST["titoloColonna2"]);
            $titoloColonna3 = $geecomDb->escapeString($_POST["titoloColonna3"]);
            $titoloColonna4 = $geecomDb->escapeString($_POST["titoloColonna4"]);

            $coloreFooterInferiore = filter_input(INPUT_POST,"coloreFooterInferiore", FILTER_SANITIZE_ADD_SLASHES);
            $coloreFooterSuperiore = filter_input(INPUT_POST,"coloreFooterSuperiore", FILTER_SANITIZE_ADD_SLASHES);
            $coloreTestiMenu       = filter_input(INPUT_POST,"coloreTestiMenu", FILTER_SANITIZE_ADD_SLASHES);

            $testo= str_replace("../immagini","immagini",$geecomDb->escapeString($_POST["testoFooter"]));

            $queryModificaFooter = "UPDATE geecD_footer SET attivaFooterSuperiore='$attivaFooterSuperiore', numeroColonne=$numeroColonne, colonna1=$colonna1, colonna2=$colonna2, colonna3=$colonna3, colonna4=$colonna4, titoloColonna1='$titoloColonna1', titoloColonna2='$titoloColonna2', titoloColonna3='$titoloColonna3', titoloColonna4='$titoloColonna4', testo='$testo', coloreFooterInferiore='$coloreFooterInferiore', coloreFooterSuperiore='$coloreFooterSuperiore', coloreTestiMenu='$coloreTestiMenu' WHERE id=$idFooter";
            $geecomDb->eseguiQueryScrittura($queryModificaFooter);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=240&lingua=$lingua");
            break;
        case 'aggiornaImpostazioniBarraMenu':
            $sfondoBarraMenu      = filter_input(INPUT_POST,"sfondoBarraMenu", FILTER_SANITIZE_ADD_SLASHES);
            $coloreTestoBarraMenu = filter_input(INPUT_POST,"coloreTestoBarraMenu", FILTER_SANITIZE_ADD_SLASHES);

            $queryModificaBarraMenu = "UPDATE geec_configurazioniAspetto SET sfondoBarraMenu='$sfondoBarraMenu', coloreTestoBarraMenu='$coloreTestoBarraMenu' WHERE selezionataDoc='si'";
            $geecomDb->eseguiQueryScrittura($queryModificaBarraMenu);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=330");
            break;
        case 'aggiornaImpostazioniBarraSuperiore':
            $menuSecondario             = $geecomDb->escapeString($_POST['menuSecondario']);
            $menuSceltaLingue           = filter_input(INPUT_POST, "menuSceltaLingue", FILTER_SANITIZE_ADD_SLASHES);
            $idMenuSecondario           = filter_input(INPUT_POST, "idMenuSecondario", FILTER_SANITIZE_NUMBER_INT);
            $allineamentoMenuSecondario = filter_input(INPUT_POST, "allineamentoMenuSecondario", FILTER_SANITIZE_ADD_SLASHES);
            $attivaBarraSuperiore       = filter_input(INPUT_POST, "attivaBarraSuperiore", FILTER_SANITIZE_ADD_SLASHES);
            $coloreBarraSuperiore       = filter_input(INPUT_POST,"coloreBarraSuperiore", FILTER_SANITIZE_ADD_SLASHES);
            $coloreTestoBarraSuperiore  = filter_input(INPUT_POST,"coloreTestoBarraSuperiore", FILTER_SANITIZE_ADD_SLASHES);
            $mostraTestoBarraSuperiore  = $geecomDb->escapeString($_POST['mostraTestoBarraSuperiore']);
            $testoBarraSuperiore        = filter_input(INPUT_POST,'testoBarraSuperiore',FILTER_SANITIZE_ADD_SLASHES);
            $allineamentoTestoBarraSuperiore = filter_input(INPUT_POST,'allineamentoTestoBarraSuperiore',FILTER_SANITIZE_ADD_SLASHES);
            
            $queryModificaBarraMenu = "UPDATE geecD_impostazioni SET attivaBarraSuperiore='$attivaBarraSuperiore', idMenuSecondario=$idMenuSecondario, allineamentoMenuSecondario='$allineamentoMenuSecondario', menuSecondario='$menuSecondario', coloreBarraSuperiore='$coloreBarraSuperiore', coloreTestoBarraSuperiore='$coloreTestoBarraSuperiore', mostraTestoBarraSuperiore='$mostraTestoBarraSuperiore', testoBarraSuperiore='$testoBarraSuperiore', allineamentoTestoBarraSuperiore='$allineamentoTestoBarraSuperiore', menuSceltaLingue='$menuSceltaLingue' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryModificaBarraMenu);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=340");
            break;
        case 'aggiornaTemplateEmail':
            $id         = filter_input(INPUT_POST,"id", FILTER_SANITIZE_NUMBER_INT);
            $nome       = filter_input(INPUT_POST,"nome", FILTER_SANITIZE_ADD_SLASHES);
            $css        = filter_input(INPUT_POST,"css", FILTER_SANITIZE_ADD_SLASHES);
            $corpoMail  = filter_input(INPUT_POST,"corpoMail", FILTER_SANITIZE_ADD_SLASHES);
            $footerMail = filter_input(INPUT_POST,"footerMail", FILTER_SANITIZE_ADD_SLASHES);

            $queryModificaFooter = "UPDATE geec_templateEmail SET nome='$nome', css='$css', corpoMail='$corpoMail', footerMail='$footerMail' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($queryModificaFooter);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=285&idTemplate=$id");
            break;
        case 'creaTemplateEmail':

            if($_FILES['immagineIntestazione']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif");
                $gestoreUpload = new GestoreUpload("immagineIntestazione", $tipiFileAmmessi, 8, "../immagini/altro", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        echo("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        echo("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $immagineIntestazione = $impostazioni["urlPiattaforma"]."/".str_replace("../","",$esitoUpload["percorso"]);
                }
            }
            
            if($_FILES['immagineFooter']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg");
                $gestoreUpload = new GestoreUpload("immagineFooter", $tipiFileAmmessi, 8, "../immagini/altro", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        echo("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        echo("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $immagineFooter = $impostazioni["urlPiattaforma"]."/".str_replace("../","",$esitoUpload["percorso"]);
                }
            }

            $immagineCentrata = "<tr>
                            <td align=\"center\">
                                <img src=\"__immagine__\" width=\"220\" height=\"65\" border=\"0\" style=\"border:0; outline:none; text-decoration:none; display:block;\">  
                            </td>
                        </tr>";
            
            $immagineATuttaLarghezza = "<tr>
                            <td align=\"center\">
                                <img src=\"__immagine__\" width=\"516\" height=\"103\" border=\"0\" style=\"border:0; outline:none; text-decoration:none; display:block;\">  
                            </td>
                        </tr>";
            
            $nome       = filter_input(INPUT_POST,"nome", FILTER_SANITIZE_ADD_SLASHES);
            
            $css = filter_input(INPUT_POST,"css", FILTER_SANITIZE_ADD_SLASHES);
            if(isset($_POST["personalizzaColoriTemplateMail"]) && $_POST["personalizzaColoriTemplateMail"]=="si") {
                $coloreSfondoMail       = filter_input(INPUT_POST,"coloreSfondoMail", FILTER_SANITIZE_ADD_SLASHES);
                $coloreIntestazioniMail = filter_input(INPUT_POST,"coloreIntestazioniMail", FILTER_SANITIZE_ADD_SLASHES);
                $coloreLink             = filter_input(INPUT_POST,"coloreLink", FILTER_SANITIZE_ADD_SLASHES);
                $coloreLinkHover        = filter_input(INPUT_POST,"coloreLinkHover", FILTER_SANITIZE_ADD_SLASHES);
                
                // eseguo i replace sostituendo i colori impostati di default con quelli scelti dall'utente
                $css = str_replace("background-color: #f6f6f6","background-color: $coloreSfondoMail",$css);
                $css = str_replace("color: #000000;","color: $coloreIntestazioniMail;",$css);
                $css = str_replace("color: #018394;","color: $coloreLink;",$css);
                $css = str_replace("background-color: #016c7a","background-color: $coloreLinkHover",$css);
            }
            $corpoMail  = filter_input(INPUT_POST,"corpoMail", FILTER_SANITIZE_ADD_SLASHES);
                    
            $tipoIntestazioneTemplateMail = filter_input(INPUT_POST,"tipoIntestazioneTemplateMail", FILTER_SANITIZE_ADD_SLASHES);
            
            if($tipoIntestazioneTemplateMail=="imgCentrata") {
                $intestazioneMail = str_replace("__immagine__",$immagineIntestazione,$immagineCentrata);
            }
            else if($tipoIntestazioneTemplateMail=="imgTuttaLarghezza") {
                $intestazioneMail = str_replace("__immagine__",$immagineIntestazione,$immagineATuttaLarghezza); 
            }
            else { // testo
                $intestazioneMail = filter_input(INPUT_POST,"intestazioneMail", FILTER_SANITIZE_ADD_SLASHES);            
            }
            $corpoMail = str_replace("__intestazione_mail__",$intestazioneMail,$corpoMail);
            
            $tipoFooterTemplateMail = filter_input(INPUT_POST,"tipoFooterTemplateMail", FILTER_SANITIZE_ADD_SLASHES);
            if($tipoFooterTemplateMail=="imgCentrata") {
                $footerMail = str_replace("__immagine__",$immagineFooter,$immagineCentrata);
            }
            else if($tipoFooterTemplateMail=="imgTuttaLarghezza") {
                $footerMail = str_replace("__immagine__",$immagineFooter,$immagineATuttaLarghezza);
            }
            else { // testo
                $footerMail = filter_input(INPUT_POST,"footerMail", FILTER_SANITIZE_ADD_SLASHES);
            }
            
            $queryModificaFooter = "INSERT INTO geec_templateEmail VALUES(NULL,'$nome','$css','$corpoMail','$footerMail')";
            $geecomDb->eseguiQueryScrittura($queryModificaFooter);
            $id = $geecomDb->idUltimoElemento();
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=285&idTemplate=$id");
            break;
        case 'aggiornaImpostazioniInclusioni':
            $inizioHead  = $geecomDb->escapeString($_POST['inizioHead']);
            $fineHead    = $geecomDb->escapeString($_POST['fineHead']);
            $inizioBody  = $geecomDb->escapeString($_POST['inizioBody']);
            $fineBody    = $geecomDb->escapeString($_POST['fineBody']);
            $footer      = $geecomDb->escapeString($_POST['inclusioneFooter']);
            $queryAggiornamentoPaginaContatti = "UPDATE geecD_inclusioni SET inizioHead='$inizioHead', fineHead='$fineHead', inizioBody='$inizioBody', fineBody='$fineBody', footer='$footer' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=250");
            break;
        case 'cambiaConfigurazioneAspetto':
            $id  = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
            $queryAzzeramentoImpostazioni = "UPDATE geec_configurazioniAspetto SET selezionataDoc = 'no'";
            $geecomDb->eseguiQueryScrittura($queryAzzeramentoImpostazioni); 
            
            $querySelezioneNuovaConfigurazione = "UPDATE geec_configurazioniAspetto SET selezionataDoc = 'si' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($querySelezioneNuovaConfigurazione);
            echo "ok";
            break;
        case 'cambiaFontConfigurazioneAspetto':
            $id         = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
            $linkFont   = filter_input(INPUT_POST,"linkFont",FILTER_SANITIZE_ADD_SLASHES);
            $fontTesti  = filter_input(INPUT_POST,"fontTesti",FILTER_SANITIZE_ADD_SLASHES);
            $fontIntestazioni = filter_input(INPUT_POST,"fontIntestazioni",FILTER_SANITIZE_ADD_SLASHES);
            
            $querySelezioneNuovaConfigurazione = "UPDATE geec_configurazioniAspetto SET linkFont='$linkFont', fontTesti='$fontTesti', fontIntestazioni='$fontIntestazioni' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($querySelezioneNuovaConfigurazione);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=320");
            break;
        case 'aggiornaColoriConfigurazione':
            $id                     = filter_input(INPUT_POST, "id", FILTER_SANITIZE_NUMBER_INT);
            $colorePrimario         = filter_input(INPUT_POST, "colorePrimario", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondario       = filter_input(INPUT_POST, "coloreSecondario", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccess          = filter_input(INPUT_POST, "coloreSuccess", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfo             = filter_input(INPUT_POST, "coloreInfo", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLight            = filter_input(INPUT_POST, "coloreLight", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDark             = filter_input(INPUT_POST, "coloreDark", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarning          = filter_input(INPUT_POST, "coloreWarning", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDanger             = filter_input(INPUT_POST, "coloreDanger", FILTER_SANITIZE_ADD_SLASHES);

            $colorePrimarioHover    = filter_input(INPUT_POST, "colorePrimarioHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondarioHover  = filter_input(INPUT_POST, "coloreSecondarioHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccessHover     = filter_input(INPUT_POST, "coloreSuccessHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfoHover        = filter_input(INPUT_POST, "coloreInfoHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLightHover       = filter_input(INPUT_POST, "coloreLightHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDarkHover        = filter_input(INPUT_POST, "coloreDarkHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarningHover        = filter_input(INPUT_POST, "coloreWarningHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDangerHover        = filter_input(INPUT_POST, "coloreDangerHover", FILTER_SANITIZE_ADD_SLASHES);

            $colorePrimarioActive   = filter_input(INPUT_POST, "colorePrimarioActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondarioActive = filter_input(INPUT_POST, "coloreSecondarioActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccessActive    = filter_input(INPUT_POST, "coloreSuccessActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfoActive       = filter_input(INPUT_POST, "coloreInfoActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLightActive      = filter_input(INPUT_POST, "coloreLightActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDarkActive       = filter_input(INPUT_POST, "coloreDarkActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarningActive    = filter_input(INPUT_POST, "coloreWarningActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDangerActive     = filter_input(INPUT_POST, "coloreDangerActive", FILTER_SANITIZE_ADD_SLASHES);

            $query = "UPDATE geec_configurazioniAspetto SET colorePrimario='$colorePrimario', coloreSecondario='$coloreSecondario', coloreSuccess='$coloreSuccess', coloreInfo='$coloreInfo', coloreLight='$coloreLight', coloreDark='$coloreDark', coloreWarning='$coloreWarning', coloreDanger='$coloreDanger',colorePrimarioHover='$colorePrimarioHover', coloreSecondarioHover='$coloreSecondarioHover', coloreSuccessHover='$coloreSuccessHover', coloreInfoHover='$coloreInfoHover', coloreLightHover='$coloreLightHover', coloreDarkHover='$coloreDarkHover', coloreWarningHover='$coloreWarningHover', coloreDangerHover='$coloreDangerHover', colorePrimarioActive='$colorePrimarioActive', coloreSecondarioActive='$coloreSecondarioActive', coloreSuccessActive='$coloreSuccessActive', coloreInfoActive='$coloreInfoActive', coloreLightActive='$coloreLightActive', coloreDarkActive='$coloreDarkActive', coloreWarningActive='$coloreWarningActive', coloreDangerActive='$coloreDangerActive' WHERE id=$id";
            $geecomDb->eseguiQueryLettura($query);

            header("Location: $percorsoGeecomDoc/impostazioni.php?status=310");
            break;        
        case 'aggiornaBreakingPointConfigurazione':
            $id                     = filter_input(INPUT_POST, "id", FILTER_SANITIZE_NUMBER_INT);
            $breakingPointsXs       = filter_input(INPUT_POST, "breakingPointXs", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsMd       = filter_input(INPUT_POST, "breakingPointMd", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsLg       = filter_input(INPUT_POST, "breakingPointLg", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsXl       = filter_input(INPUT_POST, "breakingPointXl", FILTER_SANITIZE_ADD_SLASHES);
            $query = "UPDATE geec_configurazioniAspetto SET breakingPointsXs='$breakingPointsXs', breakingPointsMd='$breakingPointsMd', breakingPointsLg='$breakingPointsLg', breakingPointsXl='$breakingPointsXl' WHERE id=$id";
            $geecomDb->eseguiQueryLettura($query);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=310");
            break;
        case 'clonaConfigurazione':

            $precendenteConfigurazioneColore = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto", "si","selezionataDoc");
            
            // per prima cosatutte le configurazioni vengono impostate a no
            $query = "UPDATE geec_configurazioniAspetto SET selezionataDoc='no'";
            $geecomDb->eseguiQueryLettura($query);
            
            $sfondoBarraMenu        = filter_input(INPUT_POST,'sfondoBarraMenu',FILTER_SANITIZE_ADD_SLASHES);
            $coloreTestoBarraMenu   = filter_input(INPUT_POST,'coloreTestoBarraMenu',FILTER_SANITIZE_ADD_SLASHES);

            $linkFont               = filter_input(INPUT_POST,'linkFont',FILTER_SANITIZE_ADD_SLASHES);
            $fontIntestazioni       = filter_input(INPUT_POST,'fontIntestazioni',FILTER_SANITIZE_ADD_SLASHES);
            $fontTesti              = filter_input(INPUT_POST,'fontTesti',FILTER_SANITIZE_ADD_SLASHES);

            $nome                   = filter_input(INPUT_POST, "nome", FILTER_SANITIZE_ADD_SLASHES);
            $descrizione            = filter_input(INPUT_POST, "note", FILTER_SANITIZE_ADD_SLASHES);
            $colorePrimario         = filter_input(INPUT_POST, "colorePrimario", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondario       = filter_input(INPUT_POST, "coloreSecondario", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccess          = filter_input(INPUT_POST, "coloreSuccess", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfo             = filter_input(INPUT_POST, "coloreInfo", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLight            = filter_input(INPUT_POST, "coloreLight", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDark             = filter_input(INPUT_POST, "coloreDark", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarning          = filter_input(INPUT_POST, "coloreWarning", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDanger             = filter_input(INPUT_POST, "coloreDanger", FILTER_SANITIZE_ADD_SLASHES);

            $colorePrimarioHover    = filter_input(INPUT_POST, "colorePrimarioHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondarioHover  = filter_input(INPUT_POST, "coloreSecondarioHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccessHover     = filter_input(INPUT_POST, "coloreSuccessHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfoHover        = filter_input(INPUT_POST, "coloreInfoHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLightHover       = filter_input(INPUT_POST, "coloreLightHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDarkHover        = filter_input(INPUT_POST, "coloreDarkHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarningHover        = filter_input(INPUT_POST, "coloreWarningHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDangerHover        = filter_input(INPUT_POST, "coloreDangerHover", FILTER_SANITIZE_ADD_SLASHES);

            $colorePrimarioActive   = filter_input(INPUT_POST, "colorePrimarioActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondarioActive = filter_input(INPUT_POST, "coloreSecondarioActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccessActive    = filter_input(INPUT_POST, "coloreSuccessActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfoActive       = filter_input(INPUT_POST, "coloreInfoActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLightActive      = filter_input(INPUT_POST, "coloreLightActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDarkActive       = filter_input(INPUT_POST, "coloreDarkActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarningActive    = filter_input(INPUT_POST, "coloreWarningActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDangerActive     = filter_input(INPUT_POST, "coloreDangerActive", FILTER_SANITIZE_ADD_SLASHES);

            $breakingPointsXs       = filter_input(INPUT_POST, "breakingPointsXs", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsMd       = filter_input(INPUT_POST, "breakingPointsMd", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsLg       = filter_input(INPUT_POST, "breakingPointsLg", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsXl       = filter_input(INPUT_POST, "breakingPointsXl", FILTER_SANITIZE_ADD_SLASHES);

            $query = "INSERT INTO `geec_configurazioniAspetto` (`id`, `nome`, `descrizione`, `selezionataCms`, `selezionataDoc`, `logo`, `logoMobile`, `favicon`, `sfondoBarraMenu`, `coloreTestoBarraMenu`, `linkFont`, `fontIntestazioni`, `fontTesti`, `colorePrimario`, `coloreSecondario`, `coloreSuccess`, `coloreInfo`, `coloreLight`, `coloreDark`, `coloreWarning`, `coloreDanger`, `colorePrimarioHover`, `coloreSecondarioHover`, `coloreSuccessHover`, `coloreInfoHover`, `coloreLightHover`, `coloreDarkHover`, `coloreWarningHover`, `coloreDangerHover`, `colorePrimarioActive`, `coloreSecondarioActive`, `coloreSuccessActive`, `coloreInfoActive`, `coloreLightActive`, `coloreDarkActive`, `coloreWarningActive`, `coloreDangerActive`, `breakingPointsXs`, `breakingPointsMd`, `breakingPointsLg`, `breakingPointsXl`)"
                    . "VALUES(NULL,'$nome','$descrizione','no','si','{$precendenteConfigurazioneColore["logo"]}','{$precendenteConfigurazioneColore["logoMobile"]}','{$precendenteConfigurazioneColore["favicon"]}','$sfondoBarraMenu','$coloreTestoBarraMenu','$linkFont','$fontIntestazioni','$fontTesti','$colorePrimario', '$coloreSecondario', '$coloreSuccess', '$coloreInfo', '$coloreLight', '$coloreDark', '$coloreWarning', '$coloreDanger','$colorePrimarioHover', '$coloreSecondarioHover', '$coloreSuccessHover', '$coloreInfoHover', '$coloreLightHover', '$coloreDarkHover', '$coloreWarningHover', '$coloreDangerHover', '$colorePrimarioActive', '$coloreSecondarioActive', '$coloreSuccessActive', '$coloreInfoActive', '$coloreLightActive', '$coloreDarkActive', '$coloreWarningActive', '$coloreDangerActive', '$breakingPointsXs', '$breakingPointsMd', '$breakingPointsLg', '$breakingPointsXl')";
            $geecomDb->eseguiQueryLettura($query);
            echo"ok";
            break;            
        case 'aggiornaImpostazioniCookie':
            $idBarraCookie     = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
            $lingua            = filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_ADD_SLASHES);
            $attivaBarraCookie = filter_input(INPUT_POST,"attivaBarraCookie",FILTER_SANITIZE_ADD_SLASHES);
            $durataCookie      = filter_input(INPUT_POST,"durataCookie",FILTER_SANITIZE_NUMBER_INT);
            $testoBarraCookie  = filter_input(INPUT_POST,"testoBarraCookie",FILTER_SANITIZE_ADD_SLASHES);
            $testoPulsanteAccetto    = filter_input(INPUT_POST,"testoPulsanteAccetto",FILTER_SANITIZE_ADD_SLASHES);
            $testoPulsanteNonAccetto = filter_input(INPUT_POST,"testoPulsanteNonAccetto",FILTER_SANITIZE_ADD_SLASHES);
            $testoPulsanteMaggioriInformazioni = filter_input(INPUT_POST,"testoPulsanteMaggioriInformazioni",FILTER_SANITIZE_ADD_SLASHES);
            $headCodiciCookie = filter_input(INPUT_POST,"headCodiciCookie",FILTER_SANITIZE_ADD_SLASHES);
            $fineBodyCookie   = filter_input(INPUT_POST,"fineBodyCookie",FILTER_SANITIZE_ADD_SLASHES);
            $mostraPulsanteMaggioriInformazioni = filter_input(INPUT_POST,"mostraPulsanteMaggioriInformazioni",FILTER_SANITIZE_ADD_SLASHES);
            $mostraPulsanteNonAccetto   = filter_input(INPUT_POST,"mostraPulsanteNonAccetto",FILTER_SANITIZE_ADD_SLASHES);
            $paginaMaggioriInformazioni = filter_input(INPUT_POST,"paginaMaggioriImpostazioni",FILTER_SANITIZE_NUMBER_INT);
            $queryAggiornamentoCookie   = "UPDATE `geecD_leggeCookie` SET `attivaBarraCookie` = '$attivaBarraCookie', `durataCookie` = '$durataCookie', `testoBarraCookie` = '$testoBarraCookie', `headCodiciCookie` = '$headCodiciCookie', `fineBodyCookie` = '$fineBodyCookie', `testoPulsanteAccetto` = '$testoPulsanteAccetto', `testoPulsanteNonAccetto` = '$testoPulsanteNonAccetto', `testoPulsanteMaggioriInformazioni` = '$testoPulsanteMaggioriInformazioni', `mostraPulsanteNonAccetto` = '$mostraPulsanteNonAccetto', `mostraPulsanteMaggioriInformazioni` = '$mostraPulsanteMaggioriInformazioni', `paginaMaggioriInformazioni` = '$paginaMaggioriInformazioni' WHERE id = $idBarraCookie;";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoCookie);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=260&lingua=$lingua");
            break;
        case 'aggiornaImpostazioniSEO':
            $testoFile         = filter_input(INPUT_POST, "contenutoFileRobots",FILTER_SANITIZE_ADD_SLASHES);
            $attivaCache       = filter_input(INPUT_POST, "attivaCache",FILTER_SANITIZE_ADD_SLASHES);
            $ottimizzazioneUrl = filter_input(INPUT_POST, "ottimizzazioneUrl",FILTER_SANITIZE_ADD_SLASHES);
            $consentiIndicizzazione = filter_input(INPUT_POST, "consentiIndicizzazione",FILTER_SANITIZE_ADD_SLASHES);

            $queryAggiornamentoPaginaContatti = "UPDATE geecD_impostazioni SET ottimizzazioneUrl='$ottimizzazioneUrl', attivaCache='$attivaCache', consentiIndicizzazione='$consentiIndicizzazione' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);
            
            //scrivo il file htaccess
            $htaccess = fopen("../.htaccess", "w");
            if($impostazioni["attivaHttps"]=="si" && $ottimizzazioneUrl=="si") {
                fwrite($htaccess, GestoreHtaccess::htaccessHttpsESeo($datiInstallazioneGeecom["percorso"]).$stringaCache);
            }
            else if($ottimizzazioneUrl=="si") { 
                fwrite($htaccess, GestoreHtaccess::htaccessSeo($datiInstallazioneGeecom["percorso"]).$stringaCache);
            }
            else if($impostazioni["attivaHttps"]=="si") { 
                fwrite($htaccess, GestoreHtaccess::htaccessHttps($datiInstallazioneGeecom["percorso"]).$stringaCache);
            }
            else if($impostazioni["attivaHttps"]=="no" && $ottimizzazioneUrl=="no") {
                fwrite($htaccess, $stringaCache); // in questo caso stampa solo il valore di attiva cache dato che gli altri due valori sono impostati a no
            }
            fclose($htaccess);

            $file = fopen("../robots.txt", "w") or die("Errore nell'aprire il file robots.txt!");
            fwrite($file, $testoFile);
            fclose($file);
            
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=270");
            break;
        case 'aggiornaImpostazioniSMTP':
            $nomeMittente  = filter_input(INPUT_POST,"nomeMittente",FILTER_SANITIZE_ADD_SLASHES);
            $emailMittente = filter_input(INPUT_POST,"emailMittente",FILTER_SANITIZE_ADD_SLASHES);
            $utenteSmtp    = filter_input(INPUT_POST,"utenteSmtp",FILTER_SANITIZE_ADD_SLASHES);
            $hostSmtp      = filter_input(INPUT_POST,"hostSmtp",FILTER_SANITIZE_ADD_SLASHES);
            $portaSmtp     = filter_input(INPUT_POST,"portaSmtp",FILTER_SANITIZE_ADD_SLASHES);
            $passwordSmtp  = filter_input(INPUT_POST,"passwordSmtp",FILTER_SANITIZE_ADD_SLASHES);
            
            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoPaginaContatti = "UPDATE geecD_impostazioni SET nomeMittente='$nomeMittente', emailMittente='$emailMittente', utenteSmtp='$utenteSmtp', hostSmtp='$hostSmtp', portaSmtp='$portaSmtp', filtraggioIP='$filtraggioIP', indirizziIPAmmessi='$indirizziIPAmmessi', indirizziIPBannati='$indirizziIPBannati', passwordSmtp='$passwordSmtp' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=275");
            break;
        case 'aggiornaImpostazioniSicurezza':
            $attivaHttps         = filter_input(INPUT_POST, "attivaHttps",FILTER_SANITIZE_ADD_SLASHES);
            $attivaFortino       = filter_input(INPUT_POST,"attivaFortino",FILTER_SANITIZE_ADD_SLASHES);
            $parolaChiaveFortino = filter_input(INPUT_POST,"parolaChiaveFortino",FILTER_SANITIZE_ADD_SLASHES);

            $filtraggioIP       = filter_input(INPUT_POST,"filtraggioIP",FILTER_SANITIZE_ADD_SLASHES);
            $indirizziIPAmmessi = filter_input(INPUT_POST,"indirizziIPAmmessi",FILTER_SANITIZE_ADD_SLASHES);
            $indirizziIPBannati = filter_input(INPUT_POST,"indirizziIPBannati",FILTER_SANITIZE_ADD_SLASHES);

            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoPaginaContatti = "UPDATE geecD_impostazioni SET attivaHttps='$attivaHttps', attivaFortino='$attivaFortino', parolaChiaveFortino='$parolaChiaveFortino', filtraggioIP='$filtraggioIP', indirizziIPAmmessi='$indirizziIPAmmessi', indirizziIPBannati='$indirizziIPBannati' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=280");
        break;
        case 'aggiornaImpostazioniProdottiInstallati':
            $percorsoCMS   = filter_input(INPUT_POST,'percorsoCMS',FILTER_SANITIZE_ADD_SLASHES);
            $percorsoAdmin = filter_input(INPUT_POST,'percorsoAdmin',FILTER_SANITIZE_ADD_SLASHES);
            $percorsoAsk   = filter_input(INPUT_POST,'percorsoAsk',FILTER_SANITIZE_ADD_SLASHES);
            $percorsoDoc   = filter_input(INPUT_POST,'percorsoDoc',FILTER_SANITIZE_ADD_SLASHES);

            $queryAggiornamento = array();
            $queryAggiornamento[count($queryAggiornamento)] = "UPDATE geec_prodotti SET percorso='$percorsoCMS' WHERE nome LIKE 'CMS'";
            $queryAggiornamento[count($queryAggiornamento)] = "UPDATE geec_prodotti SET percorso='$percorsoAdmin' WHERE nome LIKE 'Admin'";
            $queryAggiornamento[count($queryAggiornamento)] = "UPDATE geec_prodotti SET percorso='$percorsoAsk' WHERE nome LIKE 'Ask'";
            $queryAggiornamento[count($queryAggiornamento)] = "UPDATE geec_prodotti SET percorso='$percorsoDoc' WHERE nome LIKE 'Doc'";
            $geecomDb->eseguiInsiemeDiQuery($queryAggiornamento);
            header("Location: $percorsoGeecomDoc/impostazioni.php?status=290");
            break;
        
            header("Location: $percorsoGeecomDoc/creaContenuto.php?id={$datiComponente["idPagina"]}&status=350");
            break;
        case 'modificaLogo':
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif","image/svg+xml");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                    
                    //aggiorno le impostazioni con i dati passati in input
                    $queryAggiornamentoProdotto = "UPDATE geec_configurazioniAspetto SET logo='$percorsoFoto' WHERE selezionataDoc='si'";
                    $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
                    echo $esitoUpload["percorso"];
                }
            }
            break;
        case 'modificaLogoMobile':
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif","image/svg+xml");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                    
                    //aggiorno le impostazioni con i dati passati in input
                    $queryAggiornamentoProdotto = "UPDATE geec_configurazioniAspetto SET logoMobile='$percorsoFoto' WHERE selezionataDoc='si'";
                    $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
                    echo $esitoUpload["percorso"];
                }
            }
            break;
        case 'modificaFavicon':
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif","image/svg+xml","image/x-icon");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                    
                    //aggiorno le impostazioni con i dati passati in input
                    $queryAggiornamentoProdotto = "UPDATE geec_configurazioniAspetto SET favicon='$percorsoFoto' WHERE selezionataDoc='si'";
                    $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
                    echo $esitoUpload["percorso"];
                }
            }
            break;
        case 'modificaStileCss':
            if($_FILES['file']['name']=="") { //se non c'è il file no nfa niente
                
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("text/plain","text/css");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile("stile.css");
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    echo "ok";
                }
            }
            break;
        case 'scaricaFileStileCss':
            header("Content-type: text/plain");
            header("Content-disposition: attachment; filename = stile.css");
            readfile("../template/stile.css");
            break;
        case 'scaricaFileStilePhp':
            header("Content-type: text/plain");
            header("Content-disposition: attachment; filename = stile.php");
            readfile("../template/stile.php");
            break;
        case 'modificaStilePhp':
            if($_FILES['file']['name']=="") { //se non c'è il file no fa niente
                
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("text/plain","text/x-php");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile("stile.php");
                if($esitoUpload["percorso"]=="") {
                    echo $esitoUpload["errore"];
                    exit();
                }
                else {
                    echo "ok";
                }
            }
            break;
        case 'svuotaStoricoOperazioni':
            $query = "DELETE FROM geec_elementoStoricoOperazioni WHERE prodotto LIKE 'Doc'";
            $geecomDb->eseguiQueryLettura($query);
            header("Location: $percorsoGeecomDoc/strumenti/storicoOperazioni/index.php?status=200");
            break;
    }
    
    function creaComponente($geecomDb, $idComponente, $idPagina) {
        $datiComponente = $geecomDb->leggiSingolaRiga("geecD_componenti",$idComponente);
        
        if($datiComponente["tipo"]=="componenteDinamicoPagine" && $datiComponente["nome"]!="Visualizzatore galleria" && $datiComponente["tabellaRiferimento"]!="") {
            $datiPagina     = $geecomDb->leggiSingolaRiga("geecD_contenuti",$idPagina);
            $nomeComponente = $geecomDb->escapeString($datiComponente["nome"]);
            $queryInserimento = "INSERT INTO {$datiComponente["tabellaRiferimento"]} (`id`,`nome`) VALUES(NULL,'$nomeComponente pagina {$datiPagina["titolo"]}')";
            return $geecomDb->eseguiQueryCreazione($queryInserimento);            
        }
        else if($datiComponente["nome"]=="Immagine") {
            $immagine = new Immagine($geecomDb, 0, $idPagina, "immagineContenuto");
            return $immagine->crea();
        }
        else {
            return 0;
        }
    }